#include <algorithm>
#include <cmath>
#include <iostream>
#include <limits>
#include <map>
#include <vector>

void recset(std::vector<int> v, int k, std::vector<int> d, std::vector<std::vector<int>>* res, int i1 = 0, int i2 = 0) 
{
    if (i1 == k) 
    { 
        std::vector<int> set;

        for (int j = 0; j < k; j++) 
        {
            set.emplace_back(d[j]);
        }

        res->emplace_back(set);
        return; 
    } 
  
    if (i2 >= v.size()) 
    {
        return; 
    }
  
    d[i1] = v[i2]; 
    recset(v, k, d, res, i1 + 1, i2 + 1); 

    recset(v, k, d, res, i1, i2 + 1); 
}

void subset(std::vector<int> v, int k, std::vector<std::vector<int>>* res)
{
    std::vector<int> d(k);

    recset(v, k, d, res);
}

int main()
{
    int n, k;
    std::cin >> n >> k;
    std::vector<int> v(n);

    for (int i = 0; i < n; i++)
    {
        std::cin >> v[i];
    }

    if (k == (n - 1))
    {
        std::cout << 0 << std::endl;
        return 0;
    }

    //////////////////// ISTI ////////////////////

    std::map<int, int> m;
    for (int i : v)
    {
        m[i]++;
    }

    for (const auto &p : m)
    {
        if (k == (n - p.second) || ((k > (n - p.second)) && p.second >= k))
        {
            std::cout << 0 << std::endl;
            return 0;
        }
    }

    //////////////////// ISTI ////////////////////


    for (int i = 0; i < n; i++)
    {
        v[i] = std::pow(v[i], 2);
    }

    std::vector<std::vector<int>> res;
    subset(v, n - k, &res);

    int mindiff = std::numeric_limits<int>::max();
    for (const std::vector<int> &set : res)
    {
        mindiff = std::min(mindiff, (*std::max_element(set.begin(), set.end()) - *std::min_element(set.begin(), set.end())));
    }

    std::cout << mindiff << std::endl;

    return 0;
}